use "${tmp}/Regfile_nafZE", replace

	
	xtset gp year
	
	destring ZE2010, replace
	
	// define sample 
	egen mlabexid = group(mainlabex)
	qui su mlabexid
	replace mlabexid = r(max) + ZE2010 if mi(mlabexid)
	

	reghdfe ln_eng_sbrut E_post11  if NAF_labex_accept == 1 & ZE_labex_accept == 1 , a(ZE2010#year  gp)  cl(mlabexid)	
	bys gp: egen insampeng = max(e(sample))
	keep if insampeng
	 
	destring ZE2010, replace
	merge 1:1 ape ZE2010 year using "${tmp}/total_patent_ZE_ape.dta", keep(1 3) nogen
	
	recode tot_nplcits tot_patcits tot_claims  (missing = 0)
	
	qui prog_gentable E_2005, estimator("ppmlhdfe")  dep(tot_claims) fe("gp ape_n##year ZE2010#year") clust(mlabexid)  
	local row1 = "Raw patent count (weighted by claims) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
	local row2 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ " 
	keep if e(sample)
	 	
	qui prog_gentable E_2005, estimator("ppmlhdfe")  dep(tot_patcits) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row3 = "Forward citations adjusted patent count & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'   & `=e(Nobs)' obs \\"
	local row4 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ "
	
	 
	qui prog_gentable E_2005, estimator("ppmlhdfe")  dep(tot_nplcits) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row5 = "Connection to science adjusted patent count & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'   & `=e(Nobs)' obs \\"
	local row6 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ "
	
	local row0 = "& Estimate & Pre-trends test &  Obs \\"

	file open myfile using "${outpath}/table4.tex", write text replace
	forvalues i = 0/6 {
		file write myfile " `row`i''" _n
	}
	file close myfile